<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php echo $__env->yieldContent('title'); ?> - Administrator <?php echo e(Helper::web_config('nama_sekolah')); ?></title>

  <!-- Favicon -->
  <link rel="shortcut icon" type="image/icon" href="<?php if(Helper::web_config('logo') != NULL){ echo url('assets/files/logo').'/'.Helper::web_config('logo'); }else{ echo url('assets/favicon.ico'); } ?>"/>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.7 -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/bower_components/bootstrap/dist/css/bootstrap.min.css')); ?>">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/bower_components/font-awesome/css/font-awesome.min.css')); ?>">
  <!-- Ionicons -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/bower_components/Ionicons/css/ionicons.min.css')); ?>">
  <!-- jvectormap -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/bower_components/jvectormap/jquery-jvectormap.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/dist/css/AdminLTE.min.css')); ?>">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/dist/css/skins/_all-skins.min.css')); ?>">

  <!-- bootstrap datepicker -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css')); ?>">

  <!-- Sweet Select -->
  <link rel="stylesheet" href="<?php echo e(url('assets/backend/switch-select.css')); ?>">

  <!-- DataTables -->
  <link rel="stylesheet" type="text/css" href="<?php echo e(url('assets/backend/DataTables')); ?>/css/jquery.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="<?php echo e(url('assets/backend/DataTables')); ?>/css/rowReorder.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="<?php echo e(url('assets/backend/DataTables')); ?>/css/responsive.dataTables.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js')}}"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js')}}"></script>
  <![endif]-->

  <!-- Google Font -->
  <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <style>
        .hide {
            display: none;
        }

        .preloader {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background: url('<?php echo e(url('assets/loading.gif')); ?>') 50% 50% no-repeat rgb(249,249,249);
            opacity: .8;
        }
    </style>
  <?php echo $__env->yieldPushContent('style'); ?>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Page Preloder -->
<div class="preloader"></div>
<div class="wrapper">

  <header class="main-header">

    <!-- Logo -->
    <a href="<?php echo e(url('admin/')); ?>" class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>A</b>DM</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><b>Administrator</b></span>
    </a>

    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>
      <!-- Navbar Right Menu -->
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <!-- Messages: style can be found in dropdown.less-->
          <li>
            <a href="<?php echo e(url('/')); ?>" target="_blank" title="View Website">
              <i class="fa fa-eye"></i>
            </a>
          </li>
          <!-- User Account: style can be found in dropdown.less -->
          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <img src="<?php if(\Auth::user()->foto != NULL){ echo url('assets/files/profile').'/'.\Auth::user()->foto; }else{ echo url('assets/frontend/img/no-picture.png'); } ?>" class="user-image" alt="<?php echo e(\Auth::user()->name); ?>">
              <span class="hidden-xs"><?php echo e(\Auth::user()->name); ?></span>
            </a>
            <ul class="dropdown-menu">
              <!-- User image -->
              <li class="user-header">
                <img src="<?php if(\Auth::user()->foto != NULL){ echo url('assets/files/profile').'/'.\Auth::user()->foto; }else{ echo url('assets/frontend/img/no-picture.png'); } ?>" class="img-circle" alt="<?php echo e(\Auth::user()->name); ?>">

                <p>
                  <?php echo e(\Auth::user()->name); ?>

                  <small>Member since <?php echo e(date('M. Y', strtotime(\Auth::user()->created_at))); ?></small>
                </p>
              </li>
              <!-- Menu Footer-->
              <li class="user-footer">
                <div class="pull-left">
                  <a href="<?php echo e(url('admin/profile')); ?>" class="btn btn-default btn-flat">Profile</a>
                </div>
                <div class="pull-right">
                  <a class="btn btn-default btn-flat" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><?php echo e(__('Sign out')); ?></a>
                  <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                      <?php echo csrf_field(); ?>
                  </form>
                </div>
              </li>
            </ul>
          </li>
          <!-- Control Sidebar Toggle Button -->
          <li>
            <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
          </li>
        </ul>
      </div>

    </nav>
  </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <div class="user-panel">
        <div class="pull-left image">
          <img src="<?php if(\Auth::user()->foto != NULL){ echo url('assets/files/profile').'/'.\Auth::user()->foto; }else{ echo url('assets/frontend/img/no-picture.png'); } ?>" class="img-circle" alt="<?php echo e(\Auth::user()->name); ?>}">
        </div>
        <div class="pull-left info">
          <p><?php echo e(\Auth::user()->name); ?></p>
          <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
        </div>
      </div>
      <!-- search form -->
      <form action="#" method="get" class="sidebar-form">
        <div class="input-group">
          <input type="text" name="q" class="form-control" placeholder="Search...">
          <span class="input-group-btn">
                <button type="submit" name="search" id="search-btn" class="btn btn-flat">
                  <i class="fa fa-search"></i>
                </button>
              </span>
        </div>
      </form>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
      <ul class="sidebar-menu" data-widget="tree">
        <li class="header">MAIN NAVIGATION</li>
        <li class="<?php echo e(request()->is('admin') ? 'active' : ''); ?>"><a href="<?php echo e(url('admin')); ?>"><i class="fa fa-dashboard"></i> <span>Dashboard</span></a></li>
        <li class="treeview <?php echo e(request()->is(array('admin/banner', 'admin/struktur','admin/sekolah','admin/running', 'admin/link')) ? 'active' : ''); ?>">
          <a href="#">
            <i class="fa fa-home"></i>
            <span>Beranda</span>
          </a>
          <ul class="treeview-menu">
            <li class="<?php echo e(request()->is(array('admin/banner')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/banner')); ?>"><i class="fa fa-circle-o"></i> Banner</a></li>
            <li class="<?php echo e(request()->is(array('admin/struktur')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/struktur')); ?>"><i class="fa fa-circle-o"></i> Struktur Organisasi</a></li>
            <li class="<?php echo e(request()->is(array('admin/sekolah')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/sekolah')); ?>"><i class="fa fa-circle-o"></i> Management Sekolah</a></li>
            <li class="<?php echo e(request()->is(array('admin/running')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/running')); ?>"><i class="fa fa-circle-o"></i> Running Text</a></li>
            <li class="<?php echo e(request()->is(array('admin/link')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/link')); ?>"><i class="fa fa-circle-o"></i> Links</a></li>
          </ul>
        </li>
        <li class="treeview <?php echo e(request()->is(array('admin/pages', 'admin/kegiatan', 'admin/blog', 'admin/file', 'admin/gallery')) ? 'active' : ''); ?>">
          <a href="#">
            <i class="fa fa-list"></i>
            <span>Content</span>
          </a>
          <ul class="treeview-menu">
            <li class="<?php echo e(request()->is(array('admin/kegiatan')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/kegiatan')); ?>"><i class="fa fa-circle-o"></i> Kegiatan</a></li>
            <li class="<?php echo e(request()->is(array('admin/blog')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/blog')); ?>"><i class="fa fa-circle-o"></i> Blog</a></li>
            <li class="<?php echo e(request()->is(array('admin/pages')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/pages')); ?>"><i class="fa fa-circle-o"></i> Pages</a></li>
            <li class="<?php echo e(request()->is(array('admin/file')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/file')); ?>"><i class="fa fa-circle-o"></i> File Download</a></li>
            <li class="<?php echo e(request()->is(array('admin/gallery')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/gallery')); ?>"><i class="fa fa-circle-o"></i> Gallery</a></li>
          </ul>
        </li>
        <li class="treeview <?php echo e(request()->is(array('admin/profile-sekolah','admin/menu-navigasi', 'admin/api/libraries', 'admin/system/update')) ? 'active' : ''); ?>">
          <a href="#">
            <i class="fa fa-cogs"></i>
            <span>Setting</span>
          </a>
          <ul class="treeview-menu">
            <li class="<?php echo e(request()->is(array('admin/profile-sekolah')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/profile-sekolah')); ?>"><i class="fa fa-circle-o"></i> Profile Sekolah</a></li>
            <li class="<?php echo e(request()->is(array('admin/menu-navigasi')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/menu-navigasi')); ?>"><i class="fa fa-circle-o"></i> Navigasi</a></li>
            <li class="<?php echo e(request()->is(array('admin/api/libraries')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/api/libraries')); ?>"><i class="fa fa-circle-o"></i> API Libraries</a></li>
            <li class="<?php echo e(request()->is(array('admin/system/update')) ? 'active' : ''); ?>"><a href="<?php echo e(url('admin/system/update')); ?>"><i class="fa fa-circle-o"></i> Update</a></li>
          </ul>
        </li>
      </ul>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <?php echo $__env->yieldContent('content'); ?>
  </div>
  <!-- /.content-wrapper -->
  <?php echo $__env->make('layouts._modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> <?php echo e(config('webconfig.version')); ?>

    </div>
    <strong>Copyright &copy; 2019 - <?php echo e(date('Y')); ?> <a href="https://dispendik.situbondokab.go.id" target="_blank">ICT Team Dispendik Kab. Situbondo</a>.</strong> All rights
    reserved.
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>
      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->

      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>

</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="<?php echo e(url('assets/backend/bower_components/jquery/dist/jquery.min.js')); ?>"></script>
<!-- Bootstrap 3.3.7 -->
<script src="<?php echo e(url('assets/backend/bower_components/bootstrap/dist/js/bootstrap.min.js')); ?>"></script>
<!-- FastClick -->
<script src="<?php echo e(url('assets/backend/bower_components/fastclick/lib/fastclick.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(url('assets/backend/dist/js/adminlte.min.js')); ?>"></script>
<!-- Sparkline -->
<script src="<?php echo e(url('assets/backend/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js')); ?>"></script>
<!-- jvectormap  -->
<script src="<?php echo e(url('assets/backend/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js')); ?>"></script>
<script src="<?php echo e(url('assets/backend/plugins/jvectormap/jquery-jvectormap-world-mill-en.js')); ?>"></script>
<!-- SlimScroll -->
<script src="<?php echo e(url('assets/backend/bower_components/jquery-slimscroll/jquery.slimscroll.min.js')); ?>"></script>
<!-- ChartJS -->
<script src="<?php echo e(url('assets/backend/bower_components/chart.js/Chart.js')); ?>"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="<?php echo e(url('assets/backend/dist/js/pages/dashboard2.js')); ?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?php echo e(url('assets/backend/dist/js/demo.js')); ?>"></script>
<!-- bootstrap datepicker -->
<script src="<?php echo e(url('assets/backend/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>"></script>

<!-- DataTables -->
<!-- <script src="<?php echo e(url('assets/DataTables')); ?>/js/jquery-3.3.1.js"></script> -->
<script src="<?php echo e(url('assets/backend/DataTables')); ?>/js/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('assets/backend/DataTables')); ?>/js/dataTables.rowReorder.min.js"></script>
<script src="<?php echo e(url('assets/backend/DataTables')); ?>/js/dataTables.responsive.min.js"></script>

<script src="<?php echo e(url('assets/backend/sweetalert/sweetalert.min.js')); ?>"></script>
<?php echo $__env->make('sweet::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- CK Editor -->
<script src="<?php echo e(url('assets/backend/bower_components/ckeditor/ckeditor.js')); ?>"></script>
<script>
/*This makes the timeout variable global so all functions can access it.*/
var timeout;

/*This is an example function and can be disreguarded
This function sets the loading div to a given string.*/
function loaded() {
    $('.preloader').fadeOut("slow");
}
$(document).ready(function(){
    timeout = setTimeout(loaded, 1000);
})
</script>
<script type="text/javascript">
  $.fn.modal.Constructor.prototype.enforceFocus = function() {
    modal_this = this
    $(document).on('focusin.modal', function (e) {
      if (modal_this.$element[0] !== e.target && !modal_this.$element.has(e.target).length
      && !$(e.target.parentNode).hasClass('cke_dialog_ui_input_select')
      && !$(e.target.parentNode).hasClass('cke_dialog_ui_input_text')) {
        modal_this.$element.focus()
      }
    })
  };
</script>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH D:\xampp\htdocs\websekolah\webapps\resources\views/layouts/app.blade.php ENDPATH**/ ?>