@extends('layouts.app')
@section('title', 'Buku Tamu Listing')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Buku Tamu
    <small>Daftar Tamu Sekolah</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Buku Tamu</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-list"></i> Buku Tamu Sekolah</h3>
				</div>
				<div class="box-body">
                    <div class="table-responsive">
                        <table id="datatables" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Action</th>
                                    <th>Nama</th>
                                    <th>Email</th>
                                    <th>No. HP</th>
                                    <th>Tujuan</th>
                                    <th>Tanggal Dibuat</th>
                                    <th>Tanggal Update</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
				</div>
			</div>
		</div>
	</div>
</section>

@endsection

@push('scripts')
<script type="text/javascript">
$(document).ready(function(){
	var dataTable = $('#datatables').DataTable({
      "stateSave": true,
      "processing" : true,
      "serverSide" : true,
      "searching" : true,
      "ajax" : {
       "url": "{{ route('bukutamu.json') }}",
       "dataType": "json",
       "type": "GET"
      },
      "columns": [
        { data: 'DT_RowIndex', name: 'DT_RowIndex' },
        { "data": "options" },
        { "data": "nama" },
        { "data": "email" },
        { "data": "no_hp" },
        { "data": "tujuan_id" },
        { "data": "created_at" },
        { "data": "updated_at" },
      ],
    });

    $('body').on('click', '.btn-show', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').addClass('hide');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '#modal-btn-save', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        for ( instance in CKEDITOR.instances ) {
            CKEDITOR.instances[instance].updateElement();
        }
        var form = $('#modal-body form'),
            url = form.attr('action'),
            method = $('input[name=_method]').val() == undefined ? 'POST' : 'PUT';

        form.find('.help-block').remove();
        form.find('.form-group').removeClass('has-error');
        $.ajax({
        url: url,
        method: method,
        dataType: "JSON",
        data: form.serialize(),
        success: function(response){
            timeout = setTimeout(loaded, 1000);
            if(response.code === 200){
                form.trigger('reset');
                $('#modal').modal('hide');
                $('#datatables').DataTable().ajax.reload();

                swal({
                    type: 'success',
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.msg
                })
            }else{
                swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.msg
                })
            }
        },
        error: function(xhr){
            timeout = setTimeout(loaded, 1000);
            var res = xhr.responseJSON;
            if($.isEmptyObject(res) == false) {
            $.each(res.errors, function (key, value) {
                $('#' + key)
                    .closest('.form-group')
                    .addClass('has-error')
                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
            });
            }
        }
        });
    });

    $('body').on('click', '.destroy', function(e){
        var url = $(this).attr('url');
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin untuk menghapus data buku tamu ini?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, hapus!'
            ],
            dangerMode: true,
        }).then(function(isConfirm) {
            if (isConfirm) {
                $('.preloader').fadeIn();
                clearTimeout(timeout);
                $.ajax({
                type: "DELETE", // Method pengiriman data bisa dengan GET atau POST
                url: url, // Isi dengan url/path file php yang dituju
                data: {
                    _token: "{{ csrf_token() }}",
                },
                dataType: "json",
                success: function(response){
                    timeout = setTimeout(loaded, 1000);
                    if(response.code === 200){
                        $('#datatables').DataTable().ajax.reload();
                        swal({
                            title: 'Berhasil!',
                            icon: 'success',
                            text: response.msg,
                        });
                    }else{
                        swal({
                            title: 'Gagal!',
                            icon: 'error',
                            text: response.msg,
                        });
                    }
                },
                error: function(xhr){
                    timeout = setTimeout(loaded, 1000);
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: xhr.statusText,
                    });
                }
                });
            } else {
                swal("Dibatalkan", "Data batal dihapus! :)", "error");
            }
        });
    });
});
</script>
@endpush
