<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SekolahItem extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=> $this->id,
            'nama' => $this->nama,
            'jabatan' => $this->jabatan,
            'image' => $this->foto != NULL ? url('assets/files/sekolah/'.$this->foto.'?time='.time()) : NULL,
            'media' => [
                'facebook' => $this->facebook,
                'twitter' => $this->twitter,
                'instagram' => $this->instagram,
            ],
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
