@extends('layouts.app')
@section('title', 'Web Update')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Web Update
    <small>Halaman untuk update patch website</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Website Patch Update</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-list"></i> Update Website</h3>
				</div>
				<div class="box-body">
                    @if($updates == TRUE)
                    <div class="callout callout-success alert-update">
                        <h4>Update Available</h4>
                        <p>Pembaharuan website tersedia, klik tombol update dibawah ini untuk memproses update!</p>
                    </div>
                    @else
                        @if($changelog != NULL)
                        <div class="callout callout-info alert-update">
                            <h4>Changelog :</h4>
                            <p>Update version : {{env('APP_VER', '21.07.1')}}<br><?=$changelog?></p>
                        </div>
                        @endif
                    @endif
                    <form id="formUpdate" method="GET" action="{{route('system.doUpdate')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <button class="btn btn-lg btn-success" id="doUpdate" @if(!file_exists("latest-update.zip")) disabled @endif> Update</button>
                        </div>
                    </form>
                    <h4>Gunakan tombol dibawah ini jika terdapat kendala pada website untuk mengoptimasi!</h4>
                    <button class="btn btn-info btn-lg" id="optimize">Optimize Website</button>
                    <button class="btn btn-success btn-lg" id="doBackup">Backup Assets</button>
				</div>
			</div>
		</div>
	</div>
</section>

@endsection

@push('scripts')
<script>
$(document).ready(function(){
    $('body').on('click', '#doUpdate', function(e){
        e.preventDefault();
        var form = $('#formUpdate'),
            url = form.attr('action'),
            method = form.attr('method');
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin melakukan update system web?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, lanjutkan!'
            ],
            dangerMode: false,
        }).then(function(isConfirm) {
            if (isConfirm) {
                $('.preloader').fadeIn();
                clearTimeout(timeout);

                $.ajax({
                    url: url,
                    method: method,
                    dataType: "JSON",
                    success: function(response){
                        timeout = setTimeout(loaded, 1000);
                        if(response.code === 200){
                            swal({
                                type: 'success',
                                icon: 'success',
                                title: 'Berhasil!',
                                text: response.msg,
                            }).then(function(){
                                window.location.reload();
                            });
                        }else{
                            swal({
                                type: 'error',
                                icon: 'error',
                                title: 'Gagal!',
                                text: response.msg,
                            }).then(function(){
                                window.location.reload();
                            });
                        }
                    },
                    error: function(xhr){
                        timeout = setTimeout(loaded, 1000);
                        var res = xhr.responseJSON;
                        if($.isEmptyObject(res) == false) {
                            $.each(res.errors, function (key, value) {
                                $('#' + key)
                                    .closest('.form-group')
                                    .addClass('has-error')
                                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
                            });
                        }
                    }
                });
            } else {
                swal("Dibatalkan", "Batal mengupdate website! :)", "error");
            }
        });
    });

    $('body').on('click', '#optimize', function(e){
        e.preventDefault();
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin melakukan optimasi website?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, lanjutkan!'
            ],
            dangerMode: false,
        }).then(function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ route('artisan.optimize') }}",
                    method: "GET",
                    dataType: "JSON",
                    success: function(response){
                        timeout = setTimeout(loaded, 1000);
                        if(response.code === 200){
                            swal({
                                type: 'success',
                                icon: 'success',
                                title: 'Berhasil!',
                                text: response.msg,
                            }).then(function(){
                                window.location.reload();
                            });
                        }else{
                            swal({
                                type: 'error',
                                icon: 'error',
                                title: 'Gagal!',
                                text: response.msg,
                            }).then(function(){
                                window.location.reload();
                            });
                        }
                    },
                    error: function(xhr){
                        timeout = setTimeout(loaded, 1000);
                        var res = xhr.responseJSON;
                        if($.isEmptyObject(res) == false) {
                            $.each(res.errors, function (key, value) {
                                $('#' + key)
                                    .closest('.form-group')
                                    .addClass('has-error')
                                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
                            });
                        }
                    }
                });
            } else {
                swal("Dibatalkan", "Batal mengoptimasi website! :)", "error");
            }
        });
    });

    $('body').on('click', '#doBackup', function(e){
        e.preventDefault();
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin melakukan backup assets?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, lanjutkan!'
            ],
            dangerMode: false,
        }).then(function(isConfirm) {
            if (isConfirm) {
                $('.preloader').fadeIn();
                clearTimeout(timeout);

                $.ajax({
                    url: "{{ url('admin/backup?time='.time()) }}",
                    method: "GET",
                    dataType: "JSON",
                    success: function(response){
                        timeout = setTimeout(loaded, 1000);
                        if(response.code === 200){
                            swal({
                                type: 'success',
                                icon: 'success',
                                title: 'Berhasil!',
                                buttons: [
                                    'DOWNLOAD BACKUP!',
                                    'OK'
                                ],
                            }).then(function(whatNext) {
                                if (!whatNext) {
                                    window.location.href = response.download
                                }
                            });
                        }else{
                            swal({
                                type: 'error',
                                icon: 'error',
                                title: 'Gagal!',
                                text: response.msg,
                            });
                        }
                    },
                    error: function(xhr){
                        timeout = setTimeout(loaded, 1000);
                        var res = xhr.responseJSON;
                        if($.isEmptyObject(res) == false) {
                            $.each(res.errors, function (key, value) {
                                $('#' + key)
                                    .closest('.form-group')
                                    .addClass('has-error')
                                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
                            });
                        }
                    }
                });
            } else {
                swal("Dibatalkan", "Batal backup assets website! :)", "error");
            }
        });
    });
});
</script>
@endpush
