@extends('layouts.app')
@section('title', 'Menu Navigasi')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Menu Navigasi
    <small>Listing menu navigasi website</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Menu Navigasi</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-list"></i> Menu Navigasi</h3>
				</div>
				<div class="box-body">
					<a href="{{route('menu.create')}}" class="btn btn-sm btn-success modal-show" title="Form Tambah Menu"><i class="fa fa-plus"> Tambah</i></a>
          <hr>
          <div class="table-responsive">
  					<table id="datatables" class="table table-striped table-bordered table-hover">
  						<thead>
  							<tr>
                                <th>No</th>
                                <th>Action</th>
  								<th>Nama Navigasi</th>
  								<th>Slug</th>
  								<th>Parent ID</th>
  								<th>Tanggal Dibuat</th>
  								<th>Tanggal Update</th>
  							</tr>
  						</thead>
  						<tbody>
  						</tbody>
  					</table>
          </div>
				</div>
			</div>
		</div>
	</div>
</section>

@endsection

@push('scripts')
<script type="text/javascript">
$(document).ready(function(){
	var dataTable = $('#datatables').DataTable({
        "stateSave": true,
        "processing" : true,
        "serverSide" : true,
        "searching" : true,
        "ajax" : {
            "url": "{{ route('menu.json') }}",
            "dataType": "json",
            "type": "GET",
        },
        "columns": [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { "data": "options" },
            { "data": "nama" },
            { "data": "slug" },
            { "data": "parent_id" },
            { "data": "created_at" },
            { "data": "updated_at" }
        ],
        "columnDefs": [
            { "width": "2%", "targets": 0 },
            { "width": "15%", "targets": 1 },
        ],
    });

    $('body').on('click', '.modal-show', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').removeClass('hide').text(me.hasClass('edit') ? 'Ubah' : 'Simpan');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '.btn-komentar', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').removeClass('hide').text('Simpan');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '.btn-show', function (event) {
        event.preventDefault();
        var me = $(this),
            url = me.attr('href'),
            title = me.attr('title');

        $('#modal-title').text(title);
        $('#modal-btn-save').addClass('hide');

        $.ajax({
        url: url,
        dataType: 'html',
        success: function(response){
            $('#modal-body').html(response);
        }
        });

        $('#modal').modal('show');
    });

    $('body').on('click', '#modal-btn-save', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        var form = $('#modal-body form'),
            url = form.attr('action'),
            method = $('input[name=_method]').val() == undefined ? 'POST' : 'PUT';

        form.find('.help-block').remove();
        form.find('.form-group').removeClass('has-error');
        $.ajax({
        url: url,
        method: method,
        dataType: "JSON",
        data: form.serialize(),
        success: function(response){
            timeout = setTimeout(loaded, 1000);
            if(response.code === 200){
                form.trigger('reset');
                $('#modal').modal('hide');
                $('#datatables').DataTable().ajax.reload();

                swal({
                    type: 'success',
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.msg,
                })
            }else{
                swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.msg,
                })
            }
        },
        error: function(xhr){
            timeout = setTimeout(loaded, 1000);
            var res = xhr.responseJSON;
            if($.isEmptyObject(res) == false) {
            $.each(res.errors, function (key, value) {
                $('#' + key)
                    .closest('.form-group')
                    .addClass('has-error')
                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
            });
            }
        }
        });
    });

    $('body').on('click', '#destroy', function(e){
        e.preventDefault();
        var id = $(this).attr('data-id');
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin untuk menghapus menu ini ?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, hapus!'
            ],
            dangerMode: true,
        }).then(function(isConfirm) {
            if (isConfirm) {
                $('.preloader').fadeIn();
                clearTimeout(timeout);

                $.ajax({
                    type: "POST", // Method pengiriman data bisa dengan GET atau POST
                    url: "{{ route('menu.remove') }}", // Isi dengan url/path file php yang dituju
                    data: {
                        _token: "{{csrf_token()}}",
                        id: id,
                    }, // data yang akan dikirim ke file yang dituju
                    dataType: "json",
                    success: function(response){
                        timeout = setTimeout(loaded, 1000);
                        if(response.code === 200){
                            $('#datatables').DataTable().ajax.reload();
                            swal({
                                title: 'Berhasil!',
                                icon: 'success',
                                text: response.msg,
                            });
                        }else{
                            swal({
                                title: 'Gagal!',
                                icon: 'error',
                                text: response.msg,
                            });
                        }
                    },
                    error: function(xhr){
                        timeout = setTimeout(loaded, 1000);
                        swal({
                            title: 'Gagal!',
                            icon: 'error',
                            text: xhr.statusText,
                        });
                    }
                });
            } else {
                swal("Dibatalkan", "Menu Navigasi batal dihapus! :)", "error");
            }
        });
    });
});
</script>
@endpush
