@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Dashboard
    <small>Version 2.0</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Dashboard</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
  <!-- Info boxes -->
  <div class="row">
    <div class="col-md-4">
      <div class="box box-success">
        <div class="box-header with-border">
          <h3 class="box-title">Logo Sekolah</h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body">
          <div class="row">
            <div class="col-md-12 col-sm-12" id="logo">
                <a href="#" onclick="document.getElementById('logo-{{$data->id}}').click()" title="Klik untuk ganti logo"><img src="@if($data->logo != NULL ){{ url('assets/files/logo/thumbnail/'.$data->logo.'?time='.time()) }}@else{{ url('assets/frontend/img/no-picture.png?time='.time()) }}@endif" width="100%"></a>
                <form method="post" action="" enctype="multipart/form-data">
                    <input type="hidden" name="_token" id="_token" value="{{csrf_token()}}">
                    <input type="hidden" name="id" value="{{ $data->id }}">
                    <input style="display: none;" type="file" name="logo" id="logo-{{$data->id}}" data-id="{{$data->id}}" class="uploadfoto" accept="image/*">
                </form>
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->
        </div>
        <!-- /.box-body -->
      </div>
      <!-- /.box -->
    </div>

    <div class="col-md-8">
      <div class="box box-success">
        <div class="box-header with-border">
          <h3 class="box-title">Informasi Sekolah</h3>
        </div>
        <!-- /.box-header -->
        <div class="box-header with-border">
          <h3 class="box-title"><i class="fa fa-info-circle"></i> Informasi</h3>
          <input type="hidden" name="id_sekolah" id="id_sekolah" value="{{ $data->id }}">
        </div>
        <div class="box-body">
          <table class="table table-striped table-bordered table-hover">
            <tbody>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_nama_sekolah">{{$data->nama_sekolah}}</span>
                  <input type="text" class="form-control" name="nama_sekolah" id="nama_sekolah" value="{{$data->nama_sekolah}}" placeholder="Nama Sekolah" style="display: none;">
                </td>
              </tr>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_deskripsi_sekolah">{{$data->deskripsi_sekolah}}</span>
                  <input type="text" class="form-control" name="deskripsi_sekolah" id="deskripsi_sekolah" value="{{$data->deskripsi_sekolah}}" placeholder="Deskripsi Sekolah" maxlength="160" style="display: none;">
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        <div class="box-header with-border">
          <h3 class="box-title"><i class="fa fa-bookmark"></i> Media Sosial</h3>
        </div>
        <div class="box-body">
          <table class="table table-striped table-bordered table-hover">
            <tbody>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_facebook">{{$data->facebook}}</span>
                  <input type="text" class="form-control" name="facebook" id="facebook" value="{{$data->facebook}}" placeholder="Official Facebook" style="display: none;">
                </td>
              </tr>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_twitter">{{$data->twitter}}</span>
                  <input type="text" class="form-control" name="twitter" id="twitter" value="{{$data->twitter}}" placeholder="Official Twitter" style="display: none;">
                </td>
              </tr>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_instagram">{{$data->instagram}}</span>
                  <input type="text" class="form-control" name="instagram" id="instagram" value="{{$data->instagram}}" placeholder="Official Instagram" style="display: none;">
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        <div class="box-header with-border">
          <h3 class="box-title"><i class="fa fa-link"></i> Tautan</h3>
        </div>
        <div class="box-body">
          <table class="table table-striped table-bordered table-hover">
            <thead>
              <tr>
                <th>Nama Tautan</th>
                <th>Alamat Tautan</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_nama_tautan_1">{{$data->nama_tautan_1}}</span>
                  <input type="text" class="form-control" name="nama_tautan_1" id="nama_tautan_1" value="{{$data->nama_tautan_1}}" placeholder="Nama Tautan 1" style="display: none;">
                </td>
                <td title="Klik untuk edit">
                  <span id="def_tautan_1">{{$data->tautan_1}}</span>
                  <input type="text" class="form-control" name="tautan_1" id="tautan_1" value="{{$data->tautan_1}}" placeholder="Tautan 1" style="display: none;">
                </td>
              </tr>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_nama_tautan_2">{{$data->nama_tautan_2}}</span>
                  <input type="text" class="form-control" name="nama_tautan_2" id="nama_tautan_2" value="{{$data->nama_tautan_2}}" placeholder="Nama Tautan 2" style="display: none;">
                </td>
                <td title="Klik untuk edit">
                  <span id="def_tautan_2">{{$data->tautan_2}}</span>
                  <input type="text" class="form-control" name="tautan_2" id="tautan_2" value="{{$data->tautan_2}}" placeholder="Tautan 2" style="display: none;">
                </td>
              </tr>
              <tr>
                <td title="Klik untuk edit">
                  <span id="def_nama_tautan_3">{{$data->nama_tautan_3}}</span>
                  <input type="text" class="form-control" name="nama_tautan_3" id="nama_tautan_3" value="{{$data->nama_tautan_3}}" placeholder="Nama Tautan 3" style="display: none;">
                </td>
                <td title="Klik untuk edit">
                  <span id="def_tautan_3">{{$data->tautan_3}}</span>
                  <input type="text" class="form-control" name="tautan_3" id="tautan_3" value="{{$data->tautan_3}}" placeholder="Tautan 3" style="display: none;">
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        <div class="box-header with-border">
          <h3 class="box-title"><i class="fa fa-phone"></i> Kontak</h3>
        </div>
        <div class="box-body">
          <div class="table-responsive">
            <table class="table table-bordered">
              <thead>
                <tr>
                  <th>Telepon</th>
                  <th>Website</th>
                  <th>Email</th>
                  <th>Alamat</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>
                    {{-- <span>{{Helper::kontak_config('nomor_telepon', Helper::web_config('sekolah_id'))}}</span> --}}
                    <span id="def_telepon_sekolah">{{$data->telepon_sekolah ?? '-'}}</span>
                    <input type="text" class="form-control" name="telepon_sekolah" id="telepon_sekolah" value="{{$data->telepon_sekolah}}" placeholder="Telepon Sekolah" style="display: none;">
                  </td>
                  <td>
                    <span>{{Helper::kontak_config('website', Helper::web_config('sekolah_id'))}}</span>
                  </td>
                  <td>
                    {{-- <span>{{Helper::kontak_config('email', Helper::web_config('sekolah_id'))}}</span> --}}
                    <span id="def_email_sekolah">{{$data->email_sekolah ?? '-'}}</span>
                    <input type="text" class="form-control" name="email_sekolah" id="email_sekolah" value="{{$data->email_sekolah}}" placeholder="Telepon Sekolah" style="display: none;">
                  </td>
                  <td>
                    <span>{{Helper::kontak_config('alamat_jalan', Helper::web_config('sekolah_id'))}}, RT.{{Helper::kontak_config('rt', Helper::web_config('sekolah_id'))}}/RW.{{Helper::kontak_config('rw', Helper::web_config('sekolah_id'))}}. {{Helper::kontak_config('nama_dusun', Helper::web_config('sekolah_id'))}}, {{Helper::kontak_config('desa_kelurahan', Helper::web_config('sekolah_id'))}}</span>
                    <!-- <span id="def_alamat_sekolah">{{Helper::kontak_config('alamat_jalan', Helper::web_config('sekolah_id'))}}</span>
                    <input type="text" class="form-control" name="alamat_sekolah" id="alamat_sekolah" value="{{$data->alamat_sekolah}}" placeholder="Alamat Sekolah" style="display: none;"> -->
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <div class="box-header with-border">
          <h3 class="box-title"><i class="fa fa-question-circle"></i> Tutorial</h3>
        </div>
        <div class="box-body">
            <div class="col-md-12 col-sm-12">
                <a href="{{url('assets/install-website.pdf')}}" target="_blank">Tutorial Install Website</a><br>
                <a href="{{url('assets/mengisi-website.pdf')}}" target="_blank">Tutorial Mengisi Website</a>
            </div>
        </div>
        <!-- /.box-body -->

      </div>
      <!-- /.box -->
    </div>
  </div>
  <!-- /.row -->

  <!-- Main row -->
</section>
<!-- /.content -->

<div class="modal fade" id="modalInfo" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title">System Info</h3>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h4>Update Available. <a href="{{route('system.update')}}">Klik disini</a> untuk melakukan update website!</h4>
      </div>
      {{-- <div class="modal-footer">
        <button type="button" class="btn btn-primary">Save changes</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div> --}}
    </div>
  </div>
</div>

@endsection

@push('scripts')
<script type="text/javascript">
$(document).ready(function(){
    @if($updates == TRUE)
    setTimeout(function(){
        $('#modalInfo').modal('show');
    }, 3000);
    @endif

    $('#def_nama_sekolah').on('click', function(){
        document.getElementById("def_nama_sekolah").style.display="none";
        document.getElementById("nama_sekolah").style.display="block";
    });
    $('#def_deskripsi_sekolah').on('click', function(){
        document.getElementById("def_deskripsi_sekolah").style.display="none";
        document.getElementById("deskripsi_sekolah").style.display="block";
    });
    $('#def_facebook').on('click', function(){
        document.getElementById("def_facebook").style.display="none";
        document.getElementById("facebook").style.display="block";
    });
    $('#def_twitter').on('click', function(){
        document.getElementById("def_twitter").style.display="none";
        document.getElementById("twitter").style.display="block";
    });
    $('#def_instagram').on('click', function(){
        document.getElementById("def_instagram").style.display="none";
        document.getElementById("instagram").style.display="block";
    });
    $('#def_nama_tautan_1').on('click', function(){
        document.getElementById("def_nama_tautan_1").style.display="none";
        document.getElementById("nama_tautan_1").style.display="block";
    });
    $('#def_nama_tautan_2').on('click', function(){
        document.getElementById("def_nama_tautan_2").style.display="none";
        document.getElementById("nama_tautan_2").style.display="block";
    });
    $('#def_nama_tautan_3').on('click', function(){
        document.getElementById("def_nama_tautan_3").style.display="none";
        document.getElementById("nama_tautan_3").style.display="block";
    });
    $('#def_tautan_1').on('click', function(){
        document.getElementById("def_tautan_1").style.display="none";
        document.getElementById("tautan_1").style.display="block";
    });
    $('#def_tautan_2').on('click', function(){
        document.getElementById("def_tautan_2").style.display="none";
        document.getElementById("tautan_2").style.display="block";
    });
    $('#def_tautan_3').on('click', function(){
        document.getElementById("def_tautan_3").style.display="none";
        document.getElementById("tautan_3").style.display="block";
    });
    $('#def_telepon_sekolah').on('click', function(){
        document.getElementById("def_telepon_sekolah").style.display="none";
        document.getElementById("telepon_sekolah").style.display="block";
    });
    $('#def_email_sekolah').on('click', function(){
        document.getElementById("def_email_sekolah").style.display="none";
        document.getElementById("email_sekolah").style.display="block";
    });
    $('#def_alamat_sekolah').on('click', function(){
        document.getElementById("def_alamat_sekolah").style.display="none";
        document.getElementById("alamat_sekolah").style.display="block";
    });

    /*Process Update*/
    $('#nama_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_nama_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                nama_sekolah: $('#nama_sekolah').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#deskripsi_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_deskripsi_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                deskripsi_sekolah: $('#deskripsi_sekolah').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

	$('body').on('change', '.uploadfoto', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		var id = $(this).attr('data-id');
		var fileSelect = document.getElementById($(this).attr('id'));
		var token = $('#_token').val();
		var files = fileSelect.files[0];
		var formData = new FormData();
		formData.append('logo', files);
		formData.append('id', id);
		formData.append('_token', token);
		$.ajax({
            url: "{{route('profile.update_logo')}}",
            method: "POST",
            dataType: "JSON",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    $('#modal').modal('hide');
                    $('#logo').load(location.href + " #logo");
                    swal({
                        type: 'success',
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        type: 'error',
                        icon: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr, status, error){
                timeout = setTimeout(loaded, 1000);
                $('#modal').modal('hide');
                $('#datatables').DataTable().ajax.reload();
                data = JSON.parse(xhr.responseText);
                $.each(data, function(key, item){
                    swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: 'Gagal upload logo, '+item.logo+'!'
                    });
                });
            }
		});
	});

    $('#facebook').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_facebook') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                facebook: $('#facebook').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#twitter').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_twitter') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                twitter: $('#twitter').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#instagram').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_instagram') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                instagram: $('#instagram').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#nama_tautan_1').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_nama_tautan_1') }}", // Isi dengan url/path file php yang dituju
            data: {
            _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                nama_tautan_1: $('#nama_tautan_1').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#nama_tautan_2').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_nama_tautan_2') }}", // Isi dengan url/path file php yang dituju
            data: {
            _token: "{{csrf_token()}}",
            id: $('#id_sekolah').val(),
            nama_tautan_2: $('#nama_tautan_2').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#nama_tautan_3').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_nama_tautan_3') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                nama_tautan_3: $('#nama_tautan_3').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#tautan_1').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_tautan_1') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                tautan_1: $('#tautan_1').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#tautan_2').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_tautan_2') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                tautan_2: $('#tautan_2').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#tautan_3').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_tautan_3') }}", // Isi dengan url/path file php yang dituju
            data: {
            _token: "{{csrf_token()}}",
            id: $('#id_sekolah').val(),
            tautan_3: $('#tautan_3').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#telepon_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_telepon_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                telepon_sekolah: $('#telepon_sekolah').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#email_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_email_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                email_sekolah: $('#email_sekolah').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });

    $('#alamat_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "{{ route('profile.update_alamat_sekolah') }}", // Isi dengan url/path file php yang dituju
            data: {
                _token: "{{csrf_token()}}",
                id: $('#id_sekolah').val(),
                alamat_sekolah: $('#alamat_sekolah').val(),
            }, // data yang akan dikirim ke file yang dituju
            dataType: "json",
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        icon: 'success',
                        type: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        icon: 'error',
                        type: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr){
                timeout = setTimeout(loaded, 1000);
                swal({
                    icon: 'error',
                    type: 'error',
                    title: 'Gagal!',
                    text: xhr.statusText,
                });
            }
        })
    });
});
</script>
@endpush
