<?php

namespace App\Http\Controllers;

use App\Gallery;
use Illuminate\Http\Request;
use App\Http\Requests\ValidationRequest;
use Helper;
use Carbon\Carbon;
use File;
use Image;
use Alert;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('pages.be.gallerys');
    }

    function json()
    {
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        $data = Gallery::orderBy('id', 'DESC')->get();
        return DataTables::of($data)
                    ->addIndexColumn()
                    ->editColumn('options', function($row){
                        $edit = route('gallery.edit', $row->id);
                        $btn = "&emsp;<a href='{$edit}' class='btn btn-sm btn-warning modal-show edit' title='Form Edit Foto'><i class='fa fa-pencil'></i></a> <button type='button' class='btn btn-sm btn-danger' id='destroy' data-id='{$row->id}'><i class='fa fa-trash'></i></button>";
                        return $btn;
                    })
                    ->editColumn('picture', function($row){
                        if($row->picture != NULL){
                            $picture = "<img src=".url('assets/files/gallery/'.$row->picture.'?time='.time())." width='100px'>";
                        }else{
                            $picture = "<img src=".url('assets/frontend/img/no-picture.png?time='.time())." width='100px'>";
                        }
                        return $picture;
                    })
                    ->editColumn('status', function($row){
                        if($row->status == 1){
                            $status = "<label class='switch switch-primary'><input data-id='{$row->id}' type='checkbox' id='status' checked ><span></span></label>";
                        }else{
                            $status = "<label class='switch switch-primary'><input data-id='{$row->id}' type='checkbox' id='status' ><span></span></label>";
                        }
                        return $status;
                    })
                    ->editColumn('created_at', function($row){
                        return $row->created_at != NULL ? \Helper::tgl_indo($row->created_at) : "-";
                    })
                    ->editColumn('updated_at', function($row){
                        return $row->updated_at != NULL ? \Helper::tgl_indo($row->updated_at) : "-";
                    })
                    ->rawColumns(['options', 'picture', 'status'])
                    ->toJson();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $model = new Gallery();
        return view('pages.be.form_gallery', compact('model'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ValidationRequest $request)
    {
        try {
            if(!File::isDirectory('assets/files/gallery')){
                File::makeDirectory('assets/files/gallery', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/gallery/thumbnail')) {
                File::makeDirectory('assets/files/gallery/thumbnail', 0755, true, true);
            }
            $data = new Gallery();
            $file = $request->file('picture');
            $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->picture->extension();
            $path = "assets/files/gallery/".$filename;
            $uploaded = Helper::cropImage($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/gallery/".$filename;
                $thumbnailpath = "assets/files/gallery/thumbnail/". $filename;
                //create backupdata
                // Storage::disk('SFTP')->putFileAs(Helper::web_config('npsn')."/assets/files/gallery/", $path, $filename);
                // Storage::disk('SFTP')->putFileAs(Helper::web_config('npsn')."/assets/files/gallery/thumbnail", $thumbnailpath, $filename);
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 300, 225);
            }
            $data->picture = $filename;
            $data->created_at = Carbon::now('Asia/Jakarta');
            $data->updated_at = null;
            $data->save();
            \Helper::log(\Auth::user()->username, "Menambah foto gallery : ".$data->picture);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menambahkan foto ke gallery!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $model = Gallery::findOrFail($id);
        return view('pages.be.form_gallery', compact('model'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update_foto(ValidationRequest $request)
    {
        try {
            $id = $request->id;
            $gallery = Gallery::findOrFail($id);
            if(file_exists("assets/files/gallery/".$gallery->picture)){
                File::delete('assets/files/gallery/'.$gallery->picture);
                if(file_exists("assets/files/gallery/thumbnail/".$gallery->picture)){
                    File::delete('assets/files/gallery/thumbnail/'.$gallery->picture);
                }
            }
            if(!File::isDirectory('assets/files/gallery')){
                File::makeDirectory('assets/files/gallery', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/gallery/thumbnail')) {
                File::makeDirectory('assets/files/gallery/thumbnail', 0755, true, true);
            }

            $file = $request->file('picture');
            $path = $file->hashName('picture');
            $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->picture->extension();
            $path = "assets/files/gallery/".$filename;
            $uploaded = Helper::cropImage($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/gallery/".$filename;
                $thumbnailpath = "assets/files/gallery/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 300, 225);
            }
            //create backupdata
            // Storage::disk('SFTP')->putFileAs(Helper::web_config('npsn')."/assets/files/gallery/", $path, $filename);
            // Storage::disk('SFTP')->putFileAs(Helper::web_config('npsn')."/assets/files/gallery/thumbnail", $thumbnailpath, $filename);
            $data = array(
                'picture' => $filename,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $gallery->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate foto gallery : ".$gallery->picture);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate gallery!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function hapus_foto(Request $request)
    {
        try {
            $id = $request->id;
            $gallery = Gallery::findOrFail($id);
            if(file_exists("assets/files/gallery/".$gallery->picture)){
                File::delete('assets/files/gallery/'.$gallery->picture);
                if(file_exists("assets/files/gallery/thumbnail/".$gallery->picture)){
                    File::delete('assets/files/gallery/thumbnail/'.$gallery->picture);
                }
            }
            $gallery->update(['picture' => null, 'updated_at' => Carbon::now('Asia/Jakarta')]);
            \Helper::log(\Auth::user()->username, "Menghapus foto gallery : ".$gallery->picture);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menghapus foto!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function update_status(Request $request){
        try {
            $id = $request->id;
            $gallery = Gallery::findOrFail($id);
            if($gallery->status == 0){
                $data = array('status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta'));
            }else{
                $data = array('status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta'));
            }
            $gallery->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate status foto gallery : ".$gallery->picture);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti status foto!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }

    }

    public function remove(Request $request)
    {
        try {
            $id = $request->input('id');
            $gallery = Gallery::findOrFail($id);
            if(file_exists("assets/files/gallery/".$gallery->picture)){
                File::delete('assets/files/gallery/'.$gallery->picture);
                if(file_exists("assets/files/gallery/thumbnail/".$gallery->picture)){
                    File::delete('assets/files/gallery/thumbnail/'.$gallery->picture);
                }
            }
            $gallery->delete();
            \Helper::log(\Auth::user()->username, "Menghapus foto dari gallery : ".$gallery->picture);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menghapus foto dari gallery!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }

    }
}
