<?php

namespace App\Http\Controllers\Api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Banner;
use App\Http\Resources\BannerItem;
use App\Http\Resources\BannerCollection;
use App\StrukturOrganisasi;
use App\Http\Resources\StrukturItem;
use App\Http\Resources\StrukturCollection;
use App\RunningText;
use App\Http\Resources\RunningItem;
use App\Http\Resources\RunningCollection;
use App\ManagementSekolah;
use App\Http\Resources\SekolahItem;
use App\Http\Resources\SekolahCollection;
use App\Blog;
use App\Http\Resources\BlogItem;
use App\Http\Resources\BlogCollection;
use App\Pages;
use App\Http\Resources\PageItem;
use App\Http\Resources\PageCollection;
use App\Link;
use App\Http\Resources\LinkItem;
use App\Http\Resources\LinkCollection;
use App\DataFile;
use App\Http\Resources\FileItem;
use App\Http\Resources\FileCollection;
use App\Kegiatan;
use App\Http\Resources\KegiatanItem;
use App\Http\Resources\KegiatanCollection;
use App\Gallery;
use App\Http\Resources\GalleryItem;
use App\Http\Resources\GalleryCollection;
use App\ProfileSekolah;
use App\Http\Resources\ProfileSekolahItem;
use App\Http\Resources\ProfileSekolahCollection;
use App\MenuNavigasi;
use App\Http\Resources\NavigasiItem;
use App\Http\Resources\NavigasiCollection;
use App\User;
use App\Http\Resources\UserItem;
use App\Http\Resources\UserCollection;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use ZipArchive;
use Helper;
use Carbon\Carbon;
use File;
use Illuminate\Support\Facades\Hash;
use Str;

class ServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware(['auth:api', 'XssSanitizer']);
    }

    //Banner Sekolah
    public function banners()
    {
        try {
            $data = new BannerCollection(Banner::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function bannersShow(Banner $id)
    {
        try {
            $body = new BannerItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function bannersAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required',
                'desc' => 'required',
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/banner')){
                File::makeDirectory('assets/files/banner', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/banner/thumbnail')) {
                File::makeDirectory('assets/files/banner/thumbnail', 0755, true, true);
            }
            $file = $request->file('image');
            $filename = strtolower('banner-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/banner/".$filename;
            $uploaded = Helper::resizeImage($file, $path, 1200, 580);
            if($uploaded){
                $thumbnailsource = "assets/files/banner/".$filename;
                $thumbnailpath = "assets/files/banner/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
            }
            $data = [
                'name' => $request->name,
                'description' => $request->desc,
                'picture' => $filename,
                'slug' => Helper::createBannerSlug($request->name),
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $banner = Banner::create($data);
            $body = new BannerItem(Banner::findOrFail($banner->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function bannersUpdate(Request $request, $id)
    {
        try {
            $banner = Banner::findOrFail($id);
            if($request->image != NULL){
                $this->validate($request, [
                    'name' => 'required',
                    'desc' => 'required',
                    'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/banner/".$banner->picture)){
                    File::delete('assets/files/banner/'.$banner->picture);
                    if(file_exists("assets/files/banner/thumbnail/".$banner->picture)){
                        File::delete('assets/files/banner/thumbnail/'.$banner->picture);
                    }
                }

                if(!File::isDirectory('assets/files/banner')){
                    File::makeDirectory('assets/files/banner', 0755, true, true);
                }
                if(!File::isDirectory('assets/files/banner/thumbnail')) {
                    File::makeDirectory('assets/files/banner/thumbnail', 0755, true, true);
                }

                $file = $request->file('image');
                $filename = strtolower('banner-'.Helper::acakstring(8)).'.'.$request->image->extension();
                $path = "assets/files/banner/".$filename;
                $uploaded = Helper::resizeImage($file, $path, 1200, 580);
                if($uploaded){
                    $thumbnailsource = "assets/files/banner/".$filename;
                    $thumbnailpath = "assets/files/banner/thumbnail/". $filename;
                    Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
                }
                $data = [
                    'name' => $request->name,
                    'description' => $request->desc,
                    'picture' => $filename,
                    'slug' => Helper::createBannerSlug($request->name, $id),
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'name' => 'required',
                    'desc' => 'required',
                    'status' => 'required',
                ]);
                $data = [
                    'name' => $request->name,
                    'description' => $request->desc,
                    'slug' => Helper::createBannerSlug($request->name, $id),
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $banner->update($data);
            $body = new BannerItem(Banner::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function bannerDestroy($id)
    {
        try {
            $banner = Banner::findOrFail($id);

            if(file_exists("assets/files/banner/".$banner->picture)){
                File::delete('assets/files/banner/'.$banner->picture);
                if(file_exists("assets/files/banner/thumbnail/".$banner->picture)){
                    File::delete('assets/files/banner/thumbnail/'.$banner->picture);
                }
            }
            $banner->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function bannerStatus($id)
    {
        try {
            $status = Banner::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Struktur Sekolah
    public function strukturs()
    {
        try {
            $data = new StrukturItem(StrukturOrganisasi::first());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function struktursUpdate(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
            ]);

            $struktur = StrukturOrganisasi::findOrFail($id);

            if(file_exists("assets/files/struktur/".$struktur->struktur)){
                File::delete('assets/files/struktur/'.$struktur->struktur);
                if(file_exists("assets/files/struktur/thumbnail/".$struktur->struktur)){
                    File::delete('assets/files/struktur/thumbnail/'.$struktur->struktur);
                }
            }

            if(!File::isDirectory('assets/files/struktur')){
                File::makeDirectory('assets/files/struktur', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/struktur/thumbnail')) {
                File::makeDirectory('assets/files/struktur/thumbnail', 0755, true, true);
            }

            $file = $request->file('image');
            $filename = strtolower('struktur-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/struktur/".$filename;
            $uploaded = Helper::resizeImage($file, $path, 1200, 580);
            if($uploaded){
                $thumbnailsource = "assets/files/struktur/".$filename;
                $thumbnailpath = "assets/files/struktur/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
            }
            $data = [
                'struktur' => $filename,
                'status' => $request->status,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];

            $struktur->update($data);
            $body = new StrukturItem(StrukturOrganisasi::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function strukturStatus($id)
    {
        try {
            $status = StrukturOrganisasi::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Management Sekolah
    public function sekolah()
    {
        try {
            $data = new SekolahCollection(ManagementSekolah::get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function sekolahShow(ManagementSekolah $id)
    {
        try {
            $body = new SekolahItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function sekolahAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'nama' => 'required',
                'jabatan' => 'required',
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                'facebook' => 'unique:management_sekolahs',
                'twitter' => 'unique:management_sekolahs',
                'instagram' => 'unique:management_sekolahs',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/sekolah')){
                File::makeDirectory('assets/files/sekolah', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/sekolah/thumbnail')) {
                File::makeDirectory('assets/files/sekolah/thumbnail', 0755, true, true);
            }
            $file = $request->file('image');
            $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/sekolah/".$filename;
            $uploaded = Helper::resizeImageAR($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/sekolah/".$filename;
                $thumbnailpath = "assets/files/sekolah/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
            }
            $data = [
                'nama' => $request->nama,
                'jabatan' => $request->jabatan,
                'foto' => $filename,
                'facebook' => $request->facebook,
                'twitter' => $request->twitter,
                'instagram' => $request->instagram,
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $sekolah = ManagementSekolah::create($data);
            $body = new SekolahItem(ManagementSekolah::findOrFail($sekolah->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function sekolahUpdate(Request $request, $id)
    {
        try {
            $sekolah = ManagementSekolah::findOrFail($id);
            if($request->image != NULL){
                $this->validate($request, [
                    'nama' => 'required',
                    'jabatan' => 'required',
                    'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    'facebook' => 'unique:management_sekolahs,facebook,'.$id,
                    'twitter' => 'unique:management_sekolahs,twitter,'.$id,
                    'instagram' => 'unique:management_sekolahs,instagram,'.$id,
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/sekolah/".$sekolah->foto)){
                    File::delete('assets/files/sekolah/'.$sekolah->foto);
                    if(file_exists("assets/files/sekolah/thumbnail/".$sekolah->foto)){
                        File::delete('assets/files/sekolah/thumbnail/'.$sekolah->foto);
                    }
                }

                if(!File::isDirectory('assets/files/sekolah')){
                    File::makeDirectory('assets/files/sekolah', 0755, true, true);
                }
                if(!File::isDirectory('assets/files/sekolah/thumbnail')) {
                    File::makeDirectory('assets/files/sekolah/thumbnail', 0755, true, true);
                }

                $file = $request->file('image');
                $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->image->extension();
                $path = "assets/files/sekolah/".$filename;
                $uploaded = Helper::resizeImageAR($file, $path, 800, 600);
                if($uploaded){
                    $thumbnailsource = "assets/files/sekolah/".$filename;
                    $thumbnailpath = "assets/files/sekolah/thumbnail/". $filename;
                    Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
                }
                $data = [
                    'nama' => $request->nama,
                    'jabatan' => $request->jabatan,
                    'foto' => $filename,
                    'facebook' => $request->facebook,
                    'twitter' => $request->twitter,
                    'instagram' => $request->instagram,
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'nama' => 'required',
                    'jabatan' => 'required',
                    'facebook' => 'unique:management_sekolahs,facebook,'.$id,
                    'twitter' => 'unique:management_sekolahs,twitter,'.$id,
                    'instagram' => 'unique:management_sekolahs,instagram,'.$id,
                    'status' => 'required',
                ]);
                $data = [
                    'nama' => $request->nama,
                    'jabatan' => $request->jabatan,
                    'facebook' => $request->facebook,
                    'twitter' => $request->twitter,
                    'instagram' => $request->instagram,
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $sekolah->update($data);
            $body = new SekolahItem(ManagementSekolah::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function sekolahDestroy($id)
    {
        try {
            $sekolah = ManagementSekolah::findOrFail($id);

            if(file_exists("assets/files/sekolah/".$sekolah->foto)){
                File::delete('assets/files/sekolah/'.$sekolah->foto);
                if(file_exists("assets/files/sekolah/thumbnail/".$sekolah->foto)){
                    File::delete('assets/files/sekolah/thumbnail/'.$sekolah->foto);
                }
            }
            $sekolah->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function sekolahStatus($id)
    {
        try {
            $status = ManagementSekolah::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Running Text
    public function running()
    {
        try {
            $data = new RunningCollection(RunningText::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function runningShow(RunningText $id)
    {
        try {
            $body = new RunningItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function runningAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'title' => 'required',
                'text' => 'required',
                'status' => 'required',
            ]);

            $data = [
                'title' => $request->title,
                'text' => $request->text,
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $running = RunningText::create($data);
            $body = new RunningItem(RunningText::findOrFail($running->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function runningUpdate(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'title' => 'required',
                'text' => 'required',
                'status' => 'required',
            ]);

            $running = RunningText::findOrFail($id);
            $data = [
                'title' => $request->title,
                'text' => $request->text,
                'status' => $request->status,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];

            $running->update($data);
            $body = new RunningItem(RunningText::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function runningDestroy($id)
    {
        try {
            $running = RunningText::findOrFail($id);
            $running->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function runningStatus($id)
    {
        try {
            $status = RunningText::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Blog Sekolah
    public function blog()
    {
        try {
            $data = new BlogCollection(Blog::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function blogShow(Blog $id)
    {
        try {
            $body = new BlogItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function blogAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'title' => 'required',
                'content' => 'required',
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/blog')){
                File::makeDirectory('assets/files/blog', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/blog/thumbnail')) {
                File::makeDirectory('assets/files/blog/thumbnail', 0755, true, true);
            }
            $file = $request->file('image');
            $filename = strtolower('gambar-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/blog/".$filename;
            $uploaded = Helper::cropImage($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/blog/".$filename;
                $thumbnailpath = "assets/files/blog/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
            }
            $data = [
                'title' => $request->title,
                'content' => $request->content,
                'slug' => Helper::createBlogSlug($request->title),
                'picture' => $filename,
                'status' => $request->status,
                'author' => $request->author,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $blog = Blog::create($data);
            $body = new BlogItem(Blog::findOrFail($blog->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function blogUpdate(Request $request, $id)
    {
        try {
            $blog = Blog::findOrFail($id);
            if($request->image != NULL){
                $this->validate($request, [
                    'title' => 'required',
                    'content' => 'required',
                    'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/blog/".$blog->picture)){
                    File::delete('assets/files/blog/'.$blog->picture);
                    if(file_exists("assets/files/blog/thumbnail/".$blog->picture)){
                        File::delete('assets/files/blog/thumbnail/'.$blog->picture);
                    }
                }

                if(!File::isDirectory('assets/files/blog')){
                    File::makeDirectory('assets/files/blog', 0755, true, true);
                }
                if(!File::isDirectory('assets/files/blog/thumbnail')) {
                    File::makeDirectory('assets/files/blog/thumbnail', 0755, true, true);
                }

                $file = $request->file('image');
                $filename = strtolower('gambar-'.Helper::acakstring(8)).'.'.$request->image->extension();
                $path = "assets/files/blog/".$filename;
                $uploaded = Helper::cropImage($file, $path, 800, 600);
                if($uploaded){
                    $thumbnailsource = "assets/files/blog/".$filename;
                    $thumbnailpath = "assets/files/blog/thumbnail/". $filename;
                    Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
                }
                $data = [
                    'title' => $request->title,
                    'content' => $request->content,
                    'slug' => Helper::createBlogSlug($request->title, $id),
                    'picture' => $filename,
                    'status' => $request->status,
                    'author' => $request->author,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'title' => 'required',
                    'content' => 'required',
                    'status' => 'required',
                ]);
                $data = [
                    'title' => $request->title,
                    'content' => $request->content,
                    'slug' => Helper::createBlogSlug($request->title, $id),
                    'status' => $request->status,
                    'author' => $request->author,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $blog->update($data);
            $body = new BlogItem(Blog::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function blogDestroy($id)
    {
        try {
            $blog = Blog::findOrFail($id);

            if(file_exists("assets/files/blog/".$blog->picture)){
                File::delete('assets/files/blog/'.$blog->picture);
                if(file_exists("assets/files/blog/thumbnail/".$blog->picture)){
                    File::delete('assets/files/blog/thumbnail/'.$blog->picture);
                }
            }
            $blog->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function blogStatus($id)
    {
        try {
            $status = Blog::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Page Sekolah
    public function page()
    {
        try {
            $data = new PageCollection(Pages::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function pageShow(Pages $id)
    {
        try {
            $body = new PageItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function pageAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required',
                'content' => 'required',
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/pages')){
                File::makeDirectory('assets/files/pages', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/pages/thumbnail')) {
                File::makeDirectory('assets/files/pages/thumbnail', 0755, true, true);
            }
            $file = $request->file('image');
            $filename = strtolower('halaman-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/pages/".$filename;
            $uploaded = Helper::cropImage($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/pages/".$filename;
                $thumbnailpath = "assets/files/pages/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
            }
            $data = [
                'name' => $request->name,
                'content' => $request->content,
                'slug' => Helper::createPageSlug($request->name),
                'picture' => $filename,
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $pages = Pages::create($data);
            $body = new PageItem(Pages::findOrFail($pages->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function pageUpdate(Request $request, $id)
    {
        try {
            $pages = Pages::findOrFail($id);
            if($request->image != NULL){
                $this->validate($request, [
                    'name' => 'required',
                    'content' => 'required',
                    'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/pages/".$pages->picture)){
                    File::delete('assets/files/pages/'.$pages->picture);
                    if(file_exists("assets/files/pages/thumbnail/".$pages->picture)){
                        File::delete('assets/files/pages/thumbnail/'.$pages->picture);
                    }
                }

                if(!File::isDirectory('assets/files/pages')){
                    File::makeDirectory('assets/files/pages', 0755, true, true);
                }
                if(!File::isDirectory('assets/files/pages/thumbnail')) {
                    File::makeDirectory('assets/files/pages/thumbnail', 0755, true, true);
                }

                $file = $request->file('image');
                $filename = strtolower('halaman-'.Helper::acakstring(8)).'.'.$request->image->extension();
                $path = "assets/files/pages/".$filename;
                $uploaded = Helper::cropImage($file, $path, 800, 600);
                if($uploaded){
                    $thumbnailsource = "assets/files/pages/".$filename;
                    $thumbnailpath = "assets/files/pages/thumbnail/". $filename;
                    Helper::createThumbnail($thumbnailsource, $thumbnailpath, 600, 290);
                }
                $data = [
                    'name' => $request->name,
                    'content' => $request->content,
                    'slug' => Helper::createBlogSlug($request->name, $id),
                    'picture' => $filename,
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'name' => 'required',
                    'content' => 'required',
                    'status' => 'required',
                ]);
                $data = [
                    'name' => $request->name,
                    'content' => $request->content,
                    'slug' => Helper::createBlogSlug($request->name, $id),
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $pages->update($data);
            $body = new PageItem(Pages::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function pageDestroy($id)
    {
        try {
            $pages = Pages::findOrFail($id);

            if(file_exists("assets/files/pages/".$pages->picture)){
                File::delete('assets/files/pages/'.$pages->picture);
                if(file_exists("assets/files/pages/thumbnail/".$pages->picture)){
                    File::delete('assets/files/pages/thumbnail/'.$pages->picture);
                }
            }
            $pages->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function pageStatus($id)
    {
        try {
            $status = Pages::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Link Sekolah
    public function link()
    {
        try {
            $data = new LinkCollection(Link::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function linkShow(Link $id)
    {
        try {
            $body = new LinkItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function linkAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required',
                'link' => 'required|url',
                'status' => 'required',
            ]);

            $data = [
                'name' => $request->name,
                'link' => $request->link,
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $link = Link::create($data);
            $body = new LinkItem(Link::findOrFail($link->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function linkUpdate(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'name' => 'required',
                'link' => 'required|url',
                'status' => 'required',
            ]);

            $link = Link::findOrFail($id);

            $data = [
                'name' => $request->name,
                'link' => $request->link,
                'status' => $request->status,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];

            $link->update($data);
            $body = new LinkItem(Link::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function linkDestroy($id)
    {
        try {
            $link = Link::findOrFail($id);
            $link->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function linkStatus($id)
    {
        try {
            $status = Link::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Kegiatan Sekolah
    public function kegiatan()
    {
        try {
            $data = new KegiatanCollection(Kegiatan::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function kegiatanShow(Kegiatan $id)
    {
        try {
            $body = new KegiatanItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function kegiatanAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'title' => 'required',
                'caption' => 'required',
                'tanggal_kegiatan' => 'required',
                'lokasi_kegiatan' => 'required',
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/kegiatan')){
                File::makeDirectory('assets/files/kegiatan', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/kegiatan/thumbnail')) {
                File::makeDirectory('assets/files/kegiatan/thumbnail', 0755, true, true);
            }

            $file = $request->file('image');
            $filename = strtolower('kegiatan-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/kegiatan/".$filename;
            $uploaded = Helper::cropImage($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/kegiatan/".$filename;
                $thumbnailpath = "assets/files/kegiatan/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 300, 225);
            }

            $data = [
                'title' => $request->title,
                'caption' => $request->caption,
                'tanggal_kegiatan' => $request->tanggal_kegiatan,
                'lokasi_kegiatan' => $request->lokasi_kegiatan,
                'picture' => $filename,
                'slug' => Helper::createKegSlug($request->title),
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $kegiatan = Kegiatan::create($data);
            $body = new KegiatanItem(Kegiatan::findOrFail($kegiatan->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function kegiatanUpdate(Request $request, $id)
    {
        try {
            $kegiatan = Kegiatan::findOrFail($id);
            if($request->image != NULL){
                $this->validate($request, [
                    'title' => 'required',
                    'caption' => 'required',
                    'tanggal_kegiatan' => 'required',
                    'lokasi_kegiatan' => 'required',
                    'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/kegiatan/".$kegiatan->picture)){
                    File::delete('assets/files/kegiatan/'.$kegiatan->picture);
                    if(file_exists("assets/files/kegiatan/thumbnail/".$kegiatan->picture)){
                        File::delete('assets/files/kegiatan/thumbnail/'.$kegiatan->picture);
                    }
                }

                if(!File::isDirectory('assets/files/kegiatan')){
                    File::makeDirectory('assets/files/kegiatan', 0755, true, true);
                }
                if(!File::isDirectory('assets/files/kegiatan/thumbnail')) {
                    File::makeDirectory('assets/files/kegiatan/thumbnail', 0755, true, true);
                }

                $file = $request->file('image');
                $filename = strtolower('kegiatan-'.Helper::acakstring(8)).'.'.$request->image->extension();
                $path = "assets/files/kegiatan/".$filename;
                $uploaded = Helper::cropImage($file, $path, 800, 600);
                if($uploaded){
                    $thumbnailsource = "assets/files/kegiatan/".$filename;
                    $thumbnailpath = "assets/files/kegiatan/thumbnail/". $filename;
                    Helper::createThumbnail($thumbnailsource, $thumbnailpath, 300, 225);
                }

                $data = [
                    'title' => $request->title,
                    'caption' => $request->caption,
                    'tanggal_kegiatan' => $request->tanggal_kegiatan,
                    'lokasi_kegiatan' => $request->lokasi_kegiatan,
                    'picture' => $filename,
                    'slug' => Helper::createKegSlug($request->title, $id),
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'title' => 'required',
                    'caption' => 'required',
                    'tanggal_kegiatan' => 'required',
                    'lokasi_kegiatan' => 'required',
                    'status' => 'required',
                ]);
                $data = [
                    'title' => $request->title,
                    'caption' => $request->caption,
                    'tanggal_kegiatan' => $request->tanggal_kegiatan,
                    'lokasi_kegiatan' => $request->lokasi_kegiatan,
                    'slug' => Helper::createKegSlug($request->title, $id),
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $kegiatan->update($data);
            $body = new KegiatanItem(Kegiatan::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function kegiatanDestroy($id)
    {
        try {
            $kegiatan = Kegiatan::findOrFail($id);
            if(file_exists("assets/files/kegiatan/".$kegiatan->picture)){
                File::delete('assets/files/kegiatan/'.$kegiatan->picture);
                if(file_exists("assets/files/kegiatan/thumbnail/".$kegiatan->picture)){
                    File::delete('assets/files/kegiatan/thumbnail/'.$kegiatan->picture);
                }
            }
            $kegiatan->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function kegiatanStatus($id)
    {
        try {
            $status = Kegiatan::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //File Sekolah
    public function file()
    {
        try {
            $data = new FileCollection(DataFile::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function fileShow(DataFile $id)
    {
        try {
            $body = new FileItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function fileAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required',
                'file' => 'required|file|mimes:pdf,PDF,doc,DOC,docx,DOCX,xlsx,XLSX,xls,XLS,ppt,PPT,pptx,PPTX',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/file')){
                File::makeDirectory('assets/files/file', 0755, true, true);
            }

            $file = $request->file('file');
            $filename = strtolower('file-'.Str::slug(preg_replace('/\..+$/', '', $file->getClientOriginalName()), '-')).'.'.$request->file->extension();
            $file->move("assets/files/file/", $filename);

            $data = [
                'name' => $request->name,
                'file' => $filename,
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $dataFile = DataFile::create($data);
            $body = new FileItem(DataFile::findOrFail($dataFile->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function fileUpdate(Request $request, $id)
    {
        try {
            $dataFile = DataFile::findOrFail($id);
            if($request->file != NULL){
                $this->validate($request, [
                    'name' => 'required',
                    'file' => 'required|file|mimes:pdf,PDF,doc,DOC,docx,DOCX,xlsx,XLSX,xls,XLS,ppt,PPT,pptx,PPTX',
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/file/".$dataFile->file)){
                    File::delete('assets/files/file/'.$dataFile->file);
                }

                if(!File::isDirectory('assets/files/file')){
                    File::makeDirectory('assets/files/file', 0755, true, true);
                }

                $file = $request->file('file');
                $filename = strtolower('file-'.Str::slug(preg_replace('/\..+$/', '', $file->getClientOriginalName()), '-')).'.'.$request->file->extension();
                $file->move("assets/files/file/", $filename);

                $data = [
                    'name' => $request->name,
                    'file' => $filename,
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'name' => 'required',
                    'status' => 'required',
                ]);
                $data = [
                    'name' => $request->name,
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $dataFile->update($data);
            $body = new FileItem(DataFile::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function fileDestroy($id)
    {
        try {
            $dataFile = DataFile::findOrFail($id);
            if(file_exists("assets/files/file/".$dataFile->file)){
                File::delete('assets/files/file/'.$dataFile->file);
            }
            $dataFile->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }


    }

    public function fileStatus($id)
    {
        try {
            $status = DataFile::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Gallery Sekolah
    public function gallery()
    {
        try {
            $data = new GalleryCollection(Gallery::orderBy('created_at', 'desc')->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

    }

    public function galleryShow(Gallery $id)
    {
        try {
            $body = new GalleryItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function galleryAdd(Request $request)
    {
        try {
            $this->validate($request, [
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                'status' => 'required',
            ]);

            if(!File::isDirectory('assets/files/gallery')){
                File::makeDirectory('assets/files/gallery', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/gallery/thumbnail')) {
                File::makeDirectory('assets/files/gallery/thumbnail', 0755, true, true);
            }

            $file = $request->file('image');
            $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/gallery/".$filename;
            $uploaded = Helper::cropImage($file, $path, 800, 600);
            if($uploaded){
                $thumbnailsource = "assets/files/gallery/".$filename;
                $thumbnailpath = "assets/files/gallery/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 300, 225);
            }

            $data = [
                'picture' => $filename,
                'status' => $request->status,
                'created_at' => Carbon::now('Asia/Jakarta'),
            ];

            $gallery = Gallery::create($data);
            $body = new GalleryItem(Gallery::findOrFail($gallery->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function galleryUpdate(Request $request, $id)
    {
        try {
            $gallery = Gallery::findOrFail($id);
            if($request->image != NULL){
                $this->validate($request, [
                    'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    'status' => 'required',
                ]);

                if(file_exists("assets/files/gallery/".$gallery->picture)){
                    File::delete('assets/files/gallery/'.$gallery->picture);
                    if(file_exists("assets/files/gallery/thumbnail/".$gallery->picture)){
                        File::delete('assets/files/gallery/thumbnail/'.$gallery->picture);
                    }
                }

                if(!File::isDirectory('assets/files/gallery')){
                    File::makeDirectory('assets/files/gallery', 0755, true, true);
                }
                if(!File::isDirectory('assets/files/gallery/thumbnail')) {
                    File::makeDirectory('assets/files/gallery/thumbnail', 0755, true, true);
                }

                $file = $request->file('image');
                $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->image->extension();
                $path = "assets/files/gallery/".$filename;
                $uploaded = Helper::cropImage($file, $path, 800, 600);
                if($uploaded){
                    $thumbnailsource = "assets/files/gallery/".$filename;
                    $thumbnailpath = "assets/files/gallery/thumbnail/". $filename;
                    Helper::createThumbnail($thumbnailsource, $thumbnailpath, 300, 225);
                }

                $data = [
                    'picture' => $filename,
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }else{
                $this->validate($request, [
                    'status' => 'required',
                ]);
                $data = [
                    'status' => $request->status,
                    'updated_at' => Carbon::now('Asia/Jakarta'),
                ];
            }

            $gallery->update($data);
            $body = new GalleryItem(Gallery::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function galleryDestroy($id)
    {
        try {
            $gallery = Gallery::findOrFail($id);
            if(file_exists("assets/files/gallery/".$gallery->picture)){
                File::delete('assets/files/gallery/'.$gallery->picture);
                if(file_exists("assets/files/gallery/thumbnail/".$gallery->picture)){
                    File::delete('assets/files/gallery/thumbnail/'.$gallery->picture);
                }
            }
            $gallery->delete();
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function galleryStatus($id)
    {
        try {
            $status = Gallery::findOrFail($id);
            if($status->status == 1){
                $data = ['status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }else{
                $data = ['status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta')];
            }
            $status->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Profile User
    public function profileUser()
    {
        try {
            $data = new UserItem(User::first());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileUserUpdate(Request $request, $id)
    {
        try {
            $user = User::findOrFail($id);
            if($request->image != NULL){
                if($request->password != NULL){
                    $this->validate($request, [
                        'name' => 'required',
                        'email' => 'required|email',
                        'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                        'password' => 'confirmed',
                        'password_confirmation' => ''
                    ],[
                        'name.required' => 'Nama tidak boleh kosong!',
                        'email.required' => 'Email tidak boleh kosong!',
                        'image.required' => 'Foto profile harus dipilih!',
                        'image.mimes' => 'Foto profile harus berformat jpg/png/bmp!',
                        'password.confirmed' => 'Password dan Password Confirmation harus cocok!',
                    ]);
                    if(file_exists("assets/files/profile/".$user->foto)){
                        File::delete('assets/files/profile/'.$user->foto);
                        if(file_exists("assets/files/profile/thumbnail/".$user->foto)){
                            File::delete('assets/files/profile/thumbnail/'.$user->foto);
                        }
                    }
                    if(!File::isDirectory('assets/files/profile')){
                        File::makeDirectory('assets/files/profile', 0755, true, true);
                    }
                    if(!File::isDirectory('assets/files/profile/thumbnail')) {
                        File::makeDirectory('assets/files/profile/thumbnail', 0755, true, true);
                    }
                    $file = $request->file('image');
                    $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->image->extension();
                    $path = "assets/files/profile/".$filename;
                    $uploaded = Helper::resizeImage($file, $path, 600, 600);
                    if($uploaded){
                        $thumbnailsource = "assets/files/profile/".$filename;
                        $thumbnailpath = "assets/files/profile/thumbnail/". $filename;
                        Helper::createThumbnail($thumbnailsource, $thumbnailpath, 200, 200);
                    }
                    $data = array(
                        'name' => $request->name,
                        'email' => $request->email,
                        'foto' => $filename,
                        'password' => Hash::make($request->password),
                        'updated_at' => Carbon::now('Asia/Jakarta')
                    );
                }else{
                    $this->validate($request, [
                        'name' => 'required',
                        'email' => 'required|email',
                        'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
                    ],[
                        'name.required' => 'Nama tidak boleh kosong!',
                        'email.required' => 'Email tidak boleh kosong!',
                        'image.required' => 'Foto profile harus dipilih!',
                        'image.mimes' => 'Foto profile harus berformat jpg/png/bmp!',
                    ]);
                    if(file_exists("assets/files/profile/".$user->foto)){
                        File::delete('assets/files/profile/'.$user->foto);
                        if(file_exists("assets/files/profile/thumbnail/".$user->foto)){
                            File::delete('assets/files/profile/thumbnail/'.$user->foto);
                        }
                    }
                    if(!File::isDirectory('assets/files/profile')){
                        File::makeDirectory('assets/files/profile', 0755, true, true);
                    }
                    if(!File::isDirectory('assets/files/profile/thumbnail')) {
                        File::makeDirectory('assets/files/profile/thumbnail', 0755, true, true);
                    }
                    $file = $request->file('image');
                    $filename = strtolower('foto-'.Helper::acakstring(8)).'.'.$request->image->extension();
                    $path = "assets/files/profile/".$filename;
                    $uploaded = Helper::resizeImage($file, $path, 600, 600);
                    if($uploaded){
                        $thumbnailsource = "assets/files/profile/".$filename;
                        $thumbnailpath = "assets/files/profile/thumbnail/". $filename;
                        Helper::createThumbnail($thumbnailsource, $thumbnailpath, 200, 200);
                    }
                    $data = array(
                        'name' => $request->name,
                        'email' => $request->email,
                        'foto' => $filename,
                        'updated_at' => Carbon::now('Asia/Jakarta')
                    );
                }
            }else{
                if($request->password != NULL){
                    $this->validate($request, [
                        'name' => 'required',
                        'email' => 'required|email',
                        'password' => 'confirmed',
                        'password_confirmation' => ''
                    ],[
                        'name.required' => 'Nama tidak boleh kosong!',
                        'email.required' => 'Email tidak boleh kosong!',
                        'password.confirmed' => 'Password dan Password Confirmation harus cocok!',
                    ]);
                    $data = array(
                        'name' => $request->name,
                        'email' => $request->email,
                        'password' => Hash::make($request->password),
                        'updated_at' => Carbon::now('Asia/Jakarta')
                    );
                }else{
                    $this->validate($request, [
                        'name' => 'required',
                        'email' => 'required|email',
                    ],[
                        'name.required' => 'Nama tidak boleh kosong!',
                        'email.required' => 'Email tidak boleh kosong!',
                    ]);
                    $data = array(
                        'name' => $request->name,
                        'email' => $request->email,
                        'updated_at' => Carbon::now('Asia/Jakarta')
                    );
                }
            }

            $user->update($data);
            $body = new UserItem(User::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Profile Sekolah
    public function profileSekolah()
    {
        try {
            $data = new ProfileSekolahItem(ProfileSekolah::first());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateName(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'nama_sekolah' => $request->nama_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateDesc(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'deskripsi_sekolah' => $request->deskripsi_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateLogo(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'image' => 'required|file|mimes:jpg,JPG,jpeg,JPEG,png,PNG,bmp,BMP',
            ]);

            $ps = ProfileSekolah::findOrFail($id);
            if(file_exists("assets/files/logo/".$ps->logo)){
                File::delete('assets/files/logo/'.$ps->logo);
                if(file_exists("assets/files/logo/thumbnail/".$ps->logo)){
                    File::delete('assets/files/logo/thumbnail/'.$ps->logo);
                }
            }

            if(!File::isDirectory('assets/files/logo')){
                File::makeDirectory('assets/files/logo', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/logo/thumbnail')) {
                File::makeDirectory('assets/files/logo/thumbnail', 0755, true, true);
            }

            $file = $request->file('image');
            $filename = strtolower('logo'.Helper::acakstring(8)).'.'.$request->image->extension();
            $path = "assets/files/logo/".$filename;
            $uploaded = Helper::resizeImageAR($file, $path, 1000, 1000);
            if($uploaded){
                $thumbnailsource = "assets/files/logo/".$filename;
                $thumbnailpath = "assets/files/logo/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 225, 225);
            }
            $data = [
                'logo' => $filename,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateFB(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'facebook' => $request->facebook,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateTwitter(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'twitter' => $request->twitter,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateIG(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'instagram' => $request->instagram,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateTautan1(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'nama_tautan_1' => $request->nama_tautan_1,
                'tautan_1' => $request->tautan_1,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateTautan2(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'nama_tautan_2' => $request->nama_tautan_2,
                'tautan_2' => $request->tautan_2,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function profileSekolahUpdateTautan3(Request $request, $id)
    {
        try {
            $ps = ProfileSekolah::findOrFail($id);
            $data = [
                'nama_tautan_3' => $request->nama_tautan_3,
                'tautan_3' => $request->tautan_3,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $ps->update($data);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    //Navigasi
    public function navigasi()
    {
        try {
            $data = new NavigasiCollection(MenuNavigasi::get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete','body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function isParentNav()
    {
        try {
            $data = new NavigasiCollection(MenuNavigasi::where('parent_id', 0)->get());
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function navigasiShow(MenuNavigasi $id)
    {
        try {
            $body = new NavigasiItem($id);
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function navigasiStore(Request $request)
    {
        try {
            $this->validate($request, [
                'nama' => 'required|string',
                'slug' => 'required',
                'parent_id' => 'required',
            ]);

            $data = [
                'nama' => $request->nama,
                'slug' => $request->slug,
                'parent_id' => $request->parent_id,
                'created_at' => Carbon::now('Asia/Jakarta'),
                'updated_at' => NULL,
            ];
            $nav = MenuNavigasi::create($data);
            $body = new NavigasiItem(MenuNavigasi::findOrFail($nav->id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function navigasiUpdate(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'nama' => 'required|string',
                'slug' => 'required',
                'parent_id' => 'required',
            ]);

            $nav = MenuNavigasi::findOrFail($id);
            $data = [
                'nama' => $request->nama,
                'slug' => $request->slug,
                'parent_id' => $request->parent_id,
                'updated_at' => Carbon::now('Asia/Jakarta'),
            ];
            $nav->update($data);
            $body = new NavigasiItem(MenuNavigasi::findOrFail($id));
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $body], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    public function navigasiDestroy($id)
    {
        try {
            $nav = MenuNavigasi::findOrFail($id);
            if(in_array($nav->id, [1,2,3,4,5,6,9,10,11,18,19])){
                return response()->json(['code' => Response::HTTP_UNAUTHORIZED, 'status' => 'Unauthorized', 'message' => 'Navigasi '.$nav->nama.' tidak boleh dihapus!'], Response::HTTP_UNAUTHORIZED);
            }else{
                $nav->delete();
                return response()->json(['code' => Response::HTTP_OK, 'status' => 'Deleted'], Response::HTTP_OK);
            }
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    /* Version Check */
    public function versionCheck()
    {
        try {
            if(file_exists(base_path().'/CHANGELOG.txt')){
                $changelog = File::get(base_path().'/CHANGELOG.txt');
            }else{
                $changelog = "-";
            }
            $webversion = env('APP_VER', '21.07.1');
            $data = [
                'version' => $webversion,
                'changelog' => $changelog,
            ];
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'body' => $data], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => $e->errorInfo], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }

    /* Update Website */
    public function updateCheck()
    {
        if(file_exists("latest-update.zip")){
            return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'message' => 'Update tersedia!']);
        }else{
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'message' => 'Update tidak tersedia!'], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }
    public function updateWebsite()
    {
        try {
            if(file_exists("latest-update.zip")){
                $zip = new ZipArchive;
                $status = $zip->open('latest-update.zip');
                if($status === TRUE){
                    if($zip->extractTo(base_path('../'))){
                        $zip->close();
                        File::delete('latest-update.zip');
                        $path = base_path("../database/db.sql");
                        $sql = file_get_contents($path);
                        DB::unprepared($sql);
                        File::deleteDirectory("database");
                        ProfileSekolah::where('id', 1)->update(['web_version' => env('APP_VER')]);
                        return response()->json(['code' => Response::HTTP_OK, 'status' => 'Complete', 'message' => 'Updated versi website berhasil!']);
                    }else{
                        return response()->json(['code' => Response::HTTP_EXPECTATION_FAILED, 'status' => 'Failed', 'message' => 'Gagal mengekstrak update!']);
                    }
                }else{
                    return response()->json(['code' => Response::HTTP_EXPECTATION_FAILED, 'status' => 'Failed', 'message' => 'Gagal membuka update!']);
                }
            }else{
                return response()->json(['code' => Response::HTTP_EXPECTATION_FAILED, 'status' => 'Failed', 'message' => 'Update tidak tersedia!']);
            }
        } catch (QueryException $e) {
            File::deleteDirectory("database");
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'status' => 'Failed', 'message' => $e->errorInfo[2]]);
        }
    }
}
